<?php
// redirect.php universal - baca data.json dari pusat

$dataUrl = "https://short.hibernasi.site/data/data.json";

// ambil data pusat
$json = @file_get_contents($dataUrl);
if ($json === false) {
    http_response_code(500);
    echo "Gagal mengambil data pusat.";
    exit;
}

$data = json_decode($json, true);
if (!$data) {
    http_response_code(500);
    echo "Data tidak valid.";
    exit;
}

// ambil slug (tanpa ?query)
$slug = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), "/");

// cek
if (!isset($data[$slug])) {
    http_response_code(404);
    echo "Not Found";
    exit;
}

$item = $data[$slug];
$title = $item['title'] ?: "Judul Default";
$description = $item['description'] ?: "Deskripsi default";
$links = $item['links'] ?? [];
$og_image = $item['og_image'] ?? "";

// absolute URL og:image
if ($og_image && strpos($og_image, 'http') !== 0) {
    $og_image = "https://short.hibernasi.site/" . ltrim($og_image, "/");
}

if (empty($links)) {
    http_response_code(404);
    echo "Not Found";
    exit;
}

$target = $links[0];

// deteksi bot
$userAgent = strtolower($_SERVER['HTTP_USER_AGENT'] ?? "");
$isBot = preg_match('/facebookexternalhit|twitterbot|whatsapp|telegram|discord|linkedin|slack/', $userAgent);

if ($isBot) {
    // tampilkan OG tags + meta refresh
    ?>
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <title><?= htmlspecialchars($title) ?></title>
        <meta property="og:title" content="<?= htmlspecialchars($title) ?>">
        <meta property="og:description" content="<?= htmlspecialchars($description) ?>">
        <?php if ($og_image): ?>
        <meta property="og:image" content="<?= htmlspecialchars($og_image) ?>">
        <meta property="og:image:secure_url" content="<?= htmlspecialchars($og_image) ?>">
        <meta property="og:type" content="website">
        <?php endif; ?>
        <meta property="og:url" content="https://<?= $_SERVER['HTTP_HOST'] . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?>">
        <meta http-equiv="refresh" content="2;url=<?= htmlspecialchars($target) ?>">
    </head>
    <body>
        <p>Redirecting...</p>
    </body>
    </html>
    <?php
    exit;
}

// kalau bukan bot → redirect biasa
header("Location: " . $target, true, 302);
exit;
